<?php

namespace App\Models\Blog;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tags()
    {
        return $this->belongsToMany('App\Models\Blog\Tag', 'posts_tags');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Blog\Category', 'category_id');
    }

    public function views()
    {
        return $this->hasMany('App\Models\Blog\PostView', 'post_id');
    }

}